/// <reference path="vendor/jquery-1.8.3.min.js" />

$(document).ready(function () {
    __zenplanner_validateProspectForm = function (form) {
        var _this = $(this);
        _this.disabled = true;
        return true;
    }
    
    //SiteBasic.init();
    RetinaImg.init();
});

// var SiteBasic = {
//     init: function (params) {
//         SiteBasic.setForms();
//     },
//     setForms: function () {
// 		var tabindex = 1;
		
//         if ($('.mainForm').length > 0) {
//             $('.mainForm input[type="text"]').iosPlaceholder();
//             $('.mainForm input[type="tel"]').iosPlaceholder();
//             $('.mainForm input[type="email"]').iosPlaceholder();
//         }
		
// 		$('input, select').each(function () {
// 			$(this).attr('tabindex', tabindex);
// 			tabindex++;
// 		});
//     }
// }

var RetinaImg = {
    init: function () {
        RetinaImg.loadImages();  // retina img src replacement
    },
    loadImages: function () {
        var retina = false; // for test set it to true

        if (window.devicePixelRatio != "undefined" && window.devicePixelRatio >= 1.5) {
            retina = true;
        }

        $(".retina").each(function () {
            if (retina) {
                var filename = $(this).attr("data-src");
                var ext = filename.split('.').pop();

                $(this).attr("src", filename.replace("." + ext, "@2x." + ext));

                if (!($(this).attr("data-noresize"))) {
                    RetinaImg.setRealSize($(this)[0], 2);
                }
            } else {
                $(this).attr("src", $(this).attr("data-src"));
            }
        });
    },
    setRealSize: function (img, ratio) {
        var pic_real_width, pic_real_height;

        $("<img/>") // Make in memory copy of image to avoid css issues
            .attr("src", $(img).attr("src"))
            .load(function () {
                pic_real_width = this.width;   // Note: $(this).width() will not
                pic_real_height = this.height; // work for in memory images.

                $(img).attr("width", pic_real_width / ratio);
                $(img).attr("height", pic_real_height / ratio);
            });
    }
}