function initForm() {
    Array.from(document.getElementsByClassName('submit-btn')).forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            var form = this.parentElement.querySelector("form");
            form.classList.remove("show-errors");

            if (form.checkValidity()) {
                    form.submit();
                } else {
                    form.reportValidity();
                    form.classList.add("show-errors");
                }
        });
    });
}

function Modal(modalID) {
    this.container = document.getElementById(modalID);
    this.container.addEventListener('click', function (event) {
        if (event.target.id === modalID) {
            var closeModal = new Event('closeModal');
            event.target.dispatchEvent(closeModal);
        }
    });
}

Modal.prototype.show = function () {
    if (!window.reviews) {
        loadReviews();
    }

    this.container.classList.add('show');
    if (this.container.animate) {
        this.container.animate({
            opacity: [0, 1]
        }, {
            duration: 250,
            fill: 'forwards'
        });
    }
    document.getElementsByTagName("body")[0].classList.add("no-scroll");

    document.dispatchEvent(new Event('modalOpen'));
};

Modal.prototype.hide = function () {
    var _this = this;
    if (this.container.animate) {
        var animation = this.container.animate({
            opacity: [1, 0]
        }, {
            duration: 200,
            fill: 'forwards'
        });
        animation.onfinish = function () {
            _this.container.classList.remove('show');
        };
    } else {
        _this.container.classList.remove('show');
    }
    document.getElementsByTagName("body")[0].classList.remove("no-scroll");
};

function loadReviews() {
    var req = new XMLHttpRequest();
    req.open("GET", "https://cdn.njtraininggrounds.com/js/review-bundle.123791479qwasf97q9saf7a-min.js");
    req.onload = function () {
        document.getElementById('reviews-script').innerText = this.response;
        setReviews();
    };
    req.send();
}

var lazyFetched = false;
var doc = document.documentElement;

function initializePage() {
    // Check if a bot is accessing this website.
    // If so, don't process any of the content and
    // keep all of it visible for SEO purposes.
    // This will also stop code in more.js from
    // working since no 'truncated' event will be
    // triggered. This is all done for SEO purposes
    // when a SEO bot like google's bot is accessing
    // the website.
    // See utils.js for it's implementation.
    var top = (window.pageYOffset || doc.scrollTop)  - (doc.clientTop || 0);

    if (top > 20) {
        if (!isBot()) {
            window.removeEventListener('scroll', initializePage);
            if (!lazyFetched) {
                lazyFetched = true;
                fetchCSS();
            }
        }
    }
}

function fetchCSS() {
    var req = new XMLHttpRequest();
    req.open('GET', 'https://cdn.njtraininggrounds.com/styles/lazy.css');
    req.onload = function () {
        document.getElementById('lazy-css').innerText = this.response;
        fetchJS();
    };
    req.send();
}

function fetchJS() {
    var req = new XMLHttpRequest();
    req.open("GET", "https://cdn.njtraininggrounds.com/js/lazy-bundle.123791479qwasf97q9saf7a-min.js");
    req.onload = function() {
        document.getElementById('lazy').innerText = this.response;
        initEvents();
    };
    req.send();
}

window.addEventListener('scroll', initializePage, { passive: true });

window.dispatchEvent(new Event('scroll'));


function isBot() {
    let userAgent = navigator.userAgent;

    //	Convert all character cases to lower to avoid linux environment mismatching
    userAgent.toLowerCase();

    //	Define all known bot list under regex
    var BOT_REGEX = /bot|crawler|baiduspider|80legs|mediapartners-google|adsbot-google|008|abachobot|accoona-ai-agent|addsugarspiderbot|anyapexbot|arachmo|b-l-i-t-z-b-o-t|baiduspider|becomebot|beslistbot|billybobbot|bimbot|bingbot|blitzbot|boitho.com-dc|boitho.com-robot|btbot|catchbot|cerberian drtrs|charlotte|converacrawler|cosmos|covario ids|dataparksearch|diamondbot|discobot|dotbot|emeraldshield.com |webbot|esperanzabot|exabot|fast enterprise crawler|fast-webcrawler|fdse robot|findlinks|furlbot|fyberspider|g2crawler|gaisbot|galaxybot|geniebot|gigabot|girafabot|googlebot|googlebot-image|gurujibot|happyfunbot|hl_ftien_spider|holmes|htdig|iaskspider|ia_archiver|iccrawler|ichiro|igdespyder|irlbot|issuecrawler|jaxified bot|jyxobot|koepabot|l.webis|lapozzbot|larbin|ldspider|lexxebot|linguee bot|linkwalker|lmspider|lwp-trivial|mabontland|magpie-crawler|mediapartners-google|mj12bot|mnogosearch|mogimogi|mojeekbot|moreoverbot|morning paper|msnbot|msrbot|mvaclient|mxbot|netresearchserver|netseer crawler|newsgator|ng-search|nicebot|noxtrumbot|nusearch spider|nutchcvs|nymesis|obot|oegp|omgilibot|omniexplorer_bot|oozbot|orbiter|pagebiteshyperbot|peew|polybot|pompos|postpost|psbot|pycurl|pingdom.com_bot_version|qseero|radian6|rampybot|rufusbot|sandcrawler|sbider|scoutjet|scrubby|searchsight|seekbot|semanticdiscovery|sensis web crawler|seochat::bot|seznambot|shim-crawler|shopwiki|shoula robot|silk|sitebot|snappy|sogou spider|sosospider|speedy spider|sqworm|stackrambler|suggybot|surveybot|synoobot|teoma|terrawizbot|thesubot|thumbnail.cz robot|tineye|truwogps|turnitinbot|tweetedtimes bot|twengabot|updated|urlfilebot|vagabondo|voilabot|vortex|voyager|vyu2|webcollage|websquash.com|wf84|wofindeich robot|womlpefactory|xaldon_webspider|yacy|yahoo! slurp|yahoo! slurp china|yahooseeker|yahooseeker-testing|yandexbot|yandeximages|yasaklibot|yeti|yodaobot|yooglifetchagent|youdaobot|zao|zealbot|zspider|zyborg/i;

    //	if bot detect?  return true else false
    return BOT_REGEX.test(userAgent || false);
}

function sidenav() {
    if (window.location.href.indexOf('#sidebar-nav') === -1) {
            window.location.href = window.location.href.replace('#', '') + '#sidebar-nav';
            document.getElementById('nav-icon').classList.add('open');
            document.getElementById('nav-icon2').classList.add('open');
            document.querySelector('body').classList.add('no-scroll');
        } else {
            window.location.href = window.location.href.replace('sidebar-nav', '');
            document.getElementById('nav-icon').classList.remove('open');
            document.getElementById('nav-icon2').classList.remove('open');
            document.querySelector('body').classList.remove('no-scroll');
        }
}
